$(document).ready(function(){
	// $('.phoneNumber').val("+255")

	$(document).on('input', '.phoneNumber', function(){
		var phoneNumber = $(this).val().replace(/\D/g, ''); // Remove non-digit characters
        $(this).val(phoneNumber); // Update the input field value
	})
	
	$(document).on('click', '#pupilForm', function(){
		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action':'fetchPupilForm'},
			beforeSend: function(){
				$('#response01').html("<span class=\"text text-warning fw-bold\">Fetching data</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response01').html(e)
			}
		})
	})

	$(document).on('click', '#uploadExcel', function(e) {
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'excelPupilForm'},
			beforeSend: function(){
				$('#response01').html("<span class=\"text text-warning fw-bold\">Fetching data</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response01').html(e)
			}
		})
	})

	$(document).on('click', '#teacherForm', function(e) {
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'fetchTeacherForm'},
			beforeSend: function(){
				$('#response01').html("<span class=\"text text-warning fw-bold\">Fetching data</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response01').html(e)
			}
		})
	})

	$(document).on('click', '#subjectForm', function(e) {
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'fetchForms'},
			beforeSend: function(){
				$('#response01').html("<span class=\"text text-warning fw-bold\">Fetching data</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response01').html(e)
			}
		})
	})

	$(document).on('click', '#addClass', function(e){
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: {page: 'admin', action: 'classForm'},
			beforeSend: function(){
				$('#response01').html("<span class=\"text text-warning fw-bold\">Fetching data</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response01').html(e)
			}
		})
	})

	$(document).on('click', '#addSubject', function(e){
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: {page: 'admin', action: 'subjectForm'},
			beforeSend: function(){
				$('#response01').html("<span class=\"text text-warning fw-bold\">Fetching data</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response01').html(e)
			}
		})
	})

	$(document).on('submit', '#pupilsRegistration', function(e){
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#response02').html("<span class=\"text text-warning fw-bold\">Processing</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response02').html(e);
			}
		})
	})

	$(document).on('submit', '#pupilUploadForm', function(e){
		e.preventDefault();

		$.ajax({
			url: "inc/ajax_action.php",
			method: "POST",
			data: new FormData($(this)[0]),
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function(){
				$('#response02').html("<span class=\"text text-warning fw-bold\">Processing</span>:<span class=\"text text-primary fw-bold\"> Please wait... <span class=\"spinner-border spinner-border-sm align-middle ms-2\"></span></span>");
			},
			success: function(e){
				$('#response02').html(e)
			}
		})
	})
	
})